<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Tenant;
use Illuminate\Support\Facades\DB;

class TenantServiceProvider extends ServiceProvider
{
    public function register() {}

    public function boot()
    {
        if ($this->app->runningInConsole()) {
            return;
        }

        $host = request()->getHost();
        $subdomain = explode('.', $host)[0];

        $tenant = Tenant::where('subdomain', $subdomain)->first();

        if ($tenant) {
            config([
              'database.connections.tenant' => [
        'driver' => 'mysql',
        'host' => '127.0.0.1',
        'port' => '3306',
        'database' => $tenant->database, // تأكد أن اسم الحقل صحيح
        'username' => 'eltaqwa_pos_user',
        'password' => '4?%!_1qO%49,z@kM',
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
        'prefix' => '',
        'strict' => true,
        'engine' => null,
                ]
            ]);

            DB::purge('tenant');
            DB::reconnect('tenant');

            app()->instance('tenant', $tenant);
        }
    }
}


?>