<?php

namespace App\Models\Items;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;
use App\Models\Items\Item;
use App\Models\Warehouse;

class ItemGeneralQuantity extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
     protected $connection = 'tenant';
    protected $fillable = [
        'item_id',
        'warehouse_id',
        'quantity',
    ];

    /**
     * ItemTransaction item has item id
     * 
     * @return BelongsTo
     * */
    public function warehouse(): BelongsTo
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function item():BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}
