<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Config;
use App\Models\AppSettings;
use Illuminate\Support\Facades\DB;

class LoadTenantSettings
{
    public function handle($request, Closure $next)
    {
        // قاعدة البيانات تم تحديدها مسبقًا في middleware آخر
        try {
            $settings = AppSettings::first();
            if ($settings) {
                config([
                    'app.name' => $settings->application_name,
                    'app.logo' => $settings->colored_logo,
                    'app.fevicon' => $settings->fevicon,
                    'app.footer_text' => $settings->footer_text,
                ]);
            }
        } catch (\Throwable $e) {
            // سجّل أو تجاهل
        }

        return $next($request);
    }
}
?>